/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/
/** 
 * Copyright: Copyright (c) 2003
 * Company  : Clearfield Knowledge Solutions
 * @author  : Student
 * @version : 1.0
 * Date Created : Jul 11, 2003
 * Title : JavaBean.XmlGenerator.java
 * Desprition : This JavaBean class is responsible for processing request initiated 
 * from the related jsp pages and validating the inputs by using classes Validator.*
 * 
 */

/**Imported classes and packages */

package XmlCommunication;
import java.io.*;
import java.util.*;
import nz.co.cks.tms.xml.*;
import nz.co.cks.tms.xml.types.*;
import DataClasses.*;
import java.math.*;

/**
 * @author student
 *
 * This class is being used for compiling xml packets using the classes
 * generated by Castor.
 */
public class XmlGenerator {
	private static int counter = 1;
	
	/**
	 * This is the constructor for XmlGenerator.java
	 */
	public XmlGenerator(){
	}
	
	/**
	 * This method is being used for the compilation of an admin add
	 * xml packet, which adds a new ncb to the TMS.
	 * @param user User details that are to be added to TMS.
	 * @param address Address details that are to be added to TMS.
	 * @return String The xml message representing admin add.
	 */
	public String adminAddXml(User_Data user, UserAddress_Data address) {

		try {
			StringWriter writer = new StringWriter();
			System.out.println("XmlGenerator adminAddXml Started...");

			/** Initialise **/
			TmsMessage tmsMessage = new TmsMessage();

			MessageAuthBlk mab = new MessageAuthBlk();
			MessageTypeChoice mtc = new MessageTypeChoice();

			MessageAdminBlk madminb = new MessageAdminBlk();
			MessageTypeChoice mtc2 = new MessageTypeChoice(); //not needed?
			AdminAdd aa = new AdminAdd();
			Ncb ncb = new Ncb();

			NcbService ncbservice = new NcbService();

			NcbAddress ncbaddress = new NcbAddress();

			NcbTypeType ncbtypetype = NcbTypeType.valueOf(user.getType());

			/** set simpleTypes **/

			ncb.setNcbType(ncbtypetype);

			//Adding  new customer
			/** set simpleTypes **/
			ncb.setNcbType(ncbtypetype);
			if (user.getType().equals("Organisation")) {
				ncb.setName(user.getOrganisation());
				ncb.setNameLast(user.getOrganisation());
			} else {
				ncb.setName(user.getFirstName());
				ncb.setNameLast(user.getLastName());
			}
			ncb.setLogin(user.getUserName()); //generated login.
			ncb.setPassword(user.getPassword());

			Attrib att = new Attrib();
			att.setName("StockTrading");
			att.setValue("StockTrading");
			ncbservice.addAttrib(att);
			ncbservice.setServiceCode("StockTradingCode");

			NcbAddressTypeType ncbaddresstypetype =
				NcbAddressTypeType.valueOf("Billing");
			ncbaddress.setSelectedAddressType(ncbaddresstypetype);
			ncbaddress.setCity(address.getCity());
			ncbaddress.setStreetLine1(address.getStreet());
			ncbaddress.setStreetLine2(address.getSuburb());
			ncbaddress.setStreetLine3(address.getCountry());
			ncbaddress.setEmail(address.getEmail());
			ncbaddress.setPhoneNumber(address.getPhone());

			/** Add to parent **/
			aa.setNcb(ncb);
			aa.addNcbService(ncbservice);
			aa.addNcbAddress(ncbaddress);
			madminb.setAdminAdd(aa);
			mtc.setMessageAdminBlk(madminb);
			tmsMessage.setMessageTypeChoice(mtc); //adding choice.

			/** Set attributes **/
			mab.setNcbId(user.getNcbId()); //for adding new customer
			tmsMessage.setMessageAuthBlk(mab); //adding attribute.
			tmsMessage.setMessageId(counter);
			counter++;
			Date date = new Date();
			tmsMessage.setMessageDateTime(date);

			/** Get XML Packet **/
			tmsMessage.marshal(writer);

			return writer.toString();
		} catch (Exception e) {
			System.out.println("EXCEPTION! : " + e.toString());
			return null;
		}

	}


	/**
	 * This method is being used for the compilation of admin update xml
	 * oacket which is used to update a given ncb.
	 * @param user The user details that are to be updated in TMS.
	 * @param address The address details that are being updated in TMS.
	 * @return String The xml string representing the admin update xml
	 * message.
	 */
	public String adminUpdateXml(User_Data user, UserAddress_Data address) {
		try {
			StringWriter writer = new StringWriter();
			System.out.println("Started...");

			/** Initialise **/
			TmsMessage tmsMessage = new TmsMessage();

			MessageAuthBlk mab = new MessageAuthBlk();
			MessageTypeChoice mtc = new MessageTypeChoice();

			MessageAdminBlk madminb = new MessageAdminBlk();
			MessageTypeChoice mtc2 = new MessageTypeChoice(); //not needed?
			AdminUpdate au = new AdminUpdate();
			Ncb ncb = new Ncb();

			NcbService ncbservice = new NcbService();
			Attrib att = new Attrib();
			att.setName("StockTrading");
			att.setValue("StockTrading");

			/** set simpleTypes **/
			ncb.setNcbId(user.getNcbId());
			if (user.getType().equals("Organisation")) {
				ncb.setName(user.getOrganisation());
			} else {
				ncb.setName(user.getFirstName());
				ncb.setNameLast(user.getLastName());
			}
			ncb.setLogin(user.getUserName()); //generate the login.
			ncb.setPassword(user.getPassword());

			ncbservice.addAttrib(att);
			ncbservice.setServiceCode("StockTradingCode");

			NcbAddress ncbaddress = new NcbAddress();
			NcbAddressTypeType ncbaddresstypetype =
				NcbAddressTypeType.valueOf("Billing");
			ncbaddress.setSelectedAddressType(ncbaddresstypetype);

			ncbaddress.setCity(address.getCity());
			ncbaddress.setStreetLine1(address.getStreet());
			ncbaddress.setStreetLine2(address.getSuburb());
			ncbaddress.setStreetLine3(address.getCountry());
			ncbaddress.setEmail(address.getEmail());
			ncbaddress.setPhoneNumber(address.getPhone());

			/** Add to parent **/
			au.setNcb(ncb);
			au.addNcbService(ncbservice);
			au.addNcbAddress(ncbaddress);
			madminb.setAdminUpdate(au);
			mtc.setMessageAdminBlk(madminb);
			tmsMessage.setMessageTypeChoice(mtc); //adding choice.

			/** Set attributes **/
			mab.setNcbId(user.getNcbId());
			tmsMessage.setMessageAuthBlk(mab); //adding attribute.
			tmsMessage.setMessageId(counter);
			counter++;
			System.out.println(Calendar.DATE);
			Date date = new Date();
			tmsMessage.setMessageDateTime(date);

			/** Get XML Packet **/
			tmsMessage.marshal(writer);

			return writer.toString();
		} catch (Exception e) {
			System.out.println("EXCEPTION! : " + e.toString());
			return null;
		}

	}


	/**
	 * This method is being used for compilation of transactionAuth Xml
	 * packet which is used to authenticate a customer's credit account
	 * and sets up an account with TMS.
	 * @param user user details that are used for authorising the transaction.
	 * @param card Credit card details that are used for authorisation of
	 * the transaction. 
	 * @return String The xml string representing the transaction auth.
	 */
	public String transactionAuthXml(User_Data user, CreditCard_Data card) {
		try {
			StringWriter writer = new StringWriter();
			System.out.println("Transaction Auth xml Started...");

			/** Initialise **/
			TmsMessage tmsMessage = new TmsMessage();

			MessageAuthBlk mab = new MessageAuthBlk();
			MessageTypeChoice mtc = new MessageTypeChoice();

			MessageTransactionBlk mtransb = new MessageTransactionBlk();
			TransactionAuth ta = new TransactionAuth();
			CardInfo ci = new CardInfo();

			/** set simpleTypes **/
			ci.setCardName(card.getCardType());
			ci.setCardHolderName(card.getCardHolderName());
			ci.setCardNumber(card.getCardNumber());
			ci.setExpiryDate(card.getExpiryDate());

			BigDecimal bd = new BigDecimal(user.getPreBillingAmount());
			ta.setPaymentAmount(bd);
			ta.setPaymentCurrencyCode("NZD"); //refer to technical docs..
			ta.setNcbId(user.getNcbId());

			/** Add to parent **/
			ta.setCardInfo(ci);
			mtransb.setTransactionAuth(ta);
			mtc.setMessageTransactionBlk(mtransb);
			tmsMessage.setMessageTypeChoice(mtc);

			/** Set attributes **/
			mab.setNcbId(user.getNcbId());
			tmsMessage.setMessageAuthBlk(mab); //adding attribute.
			tmsMessage.setMessageId(counter);
			counter++;
			Date date = new Date();
			tmsMessage.setMessageDateTime(date);

			/** Get XML Packet **/
			tmsMessage.marshal(writer);

			return writer.toString();

		} catch (Exception e) {

			System.out.println("EXCEPTION! : " + e.toString());
			return null;
		}
	}
	
	/**
	 * This method is being used for the compilation of transaction purchase
	 * xml packet which is used to identify a purchase order.
	 * @param stock Stock details that are used for transaction purchase. 
	 * @param user User details that are used for transaction purchase.
	 * @param address Address details that are used for the transaction
	 * purchase.
	 * @return String The xml string that represents the transaction purchase.
	 */
	public String transactionPurchaseXml(
		Stock_Data stock,
		User_Data user,
		UserAddress_Data address) {
		try {
			StringWriter writer = new StringWriter();
			System.out.println("Started...");

			/** Initialise */
			TmsMessage tmsMessage = new TmsMessage();

			MessageAuthBlk mab = new MessageAuthBlk();
			MessageTypeChoice mtc = new MessageTypeChoice();

			MessageTransactionBlk mtransb = new MessageTransactionBlk();
			TransactionPurchase tp = new TransactionPurchase();

			Ncb ncb = new Ncb();
			NcbAddress ncbaddress = new NcbAddress();
			NcbAddressTypeType ncbaddresstypetype =
				NcbAddressTypeType.valueOf("Billing");
			PurchaseItem pi = new PurchaseItem();

			/** set simpleTypes */
			pi.setItemCode(stock.getStockCode());
			pi.setItemQuantity(Integer.parseInt(stock.getQuantity()));
			pi.setServiceCode(stock.getServiceCode());
			pi.setServiceRequest(stock.getServiceRequest());
			pi.setServiceResponse(stock.getServiceResponse());

			ncb.setNcbId(user.getNcbId());
			ncb.setName(user.getFirstName());

			/** Add to parent */
			tp.setNcb(ncb);
			tp.addPurchaseItem(pi);
			tp.setPaymentCurrencyCode("NZD");

			mtransb.setTransactionPurchase(tp);
			mtc.setMessageTransactionBlk(mtransb);
			tmsMessage.setMessageTypeChoice(mtc);

			/** Set attributes */
			mab.setNcbId(user.getNcbId());

			tmsMessage.setMessageAuthBlk(mab); //adding attribute.
			tmsMessage.setMessageId(counter);
			counter++;
			Date date = new Date();
			tmsMessage.setMessageDateTime(date);

			/** Get XML Packet */
			tmsMessage.marshal(writer);
			System.out.println("finder");

			return writer.toString();
		} catch (Exception e) {
			System.out.println("EXCEPTION! : " + e.toString());
			return null;
		}
	}
	
	/**
	 * This method is being used for the compilation of transaction settlement
	 * xml packet which asks for the confirmation of the transaction.
	 * @param user User details that are being used for the transaction
	 * settlement.
	 * @param card Credit card details that are being used for the transaction 
	 * settlement.
	 * @param stock Stock details that are being used for the transaction 
	 * settlement.
	 * @return String The xml string representing the transaction settlement.
	 */
	public String transactionSettlementXml(
		User_Data user,
		CreditCard_Data card,
		Stock_Data stock) {
		try {
			//FileWriter writer = new FileWriter("test.xml");
			StringWriter writer = new StringWriter();
			System.out.println("Started...");

			/** Initialise */
			TmsMessage tmsMessage = new TmsMessage();

			MessageAuthBlk mab = new MessageAuthBlk();
			MessageTypeChoice mtc = new MessageTypeChoice();

			MessageTransactionBlk mtransb = new MessageTransactionBlk();
			TransactionSettlement ts = new TransactionSettlement();

			/** set simpleTypes */
			double d =
				Double.parseDouble(stock.getQuantity()) * stock.getPrice();
			String str = String.valueOf(d);

			BigDecimal bd = new BigDecimal(str);
			ts.setPaymentAmount(bd);
			ts.setPaymentCurrencyCode("NZD"); //refer to technical docs..
			ts.setNcbId(user.getNcbId());

			/** Add to parent */
			mtransb.setTransactionSettlement(ts);
			mtc.setMessageTransactionBlk(mtransb);
			tmsMessage.setMessageTypeChoice(mtc);

			/** Set attributes */
			mab.setNcbId(user.getNcbId());
			tmsMessage.setMessageAuthBlk(mab); //adding attribute.
			tmsMessage.setMessageId(counter);
			counter++;
			Date date = new Date();
			tmsMessage.setMessageDateTime(date);

			/** Get XML Packet */
			tmsMessage.marshal(writer);

			return writer.toString();
		} catch (Exception e) {
			System.out.println("EXCEPTION! : " + e.toString());
			return null;
		}
	}
	
	/**
	 * This method is being used for the compilation of enquiry ncb xml
	 * packet which gets the given ncb's data from TMS.
	 * @param user User details for whom enquiry ncb is being sent.
	 * @param card Credit card details that are used for the enquiry ncb.
	 * @return String The xml string that represents theenquiry ncb.
	 */
	public String enquiryNcbXml(User_Data user, CreditCard_Data card) {
		try {
			//FileWriter writer = new FileWriter("test.xml");
			StringWriter writer = new StringWriter();
			System.out.println("Started...");

			/** Initialise */
			TmsMessage tmsMessage = new TmsMessage();

			MessageAuthBlk mab = new MessageAuthBlk();
			MessageTypeChoice mtc = new MessageTypeChoice();

			MessageEnquiryBlk menquiryb = new MessageEnquiryBlk();
			//MessageTypeChoice mtc2 = new MessageTypeChoice(); //not needed?
			EnquiryNcb en = new EnquiryNcb();

			/** set simpleTypes */
			en.setNcbId(user.getNcbId());

			/** Add to parent */
			menquiryb.setEnquiryNcb(en);
			mtc.setMessageEnquiryBlk(menquiryb);
			tmsMessage.setMessageTypeChoice(mtc);

			/** Set attributes */
			mab.setNcbId(user.getNcbId());
			tmsMessage.setMessageAuthBlk(mab); //adding attribute.
			tmsMessage.setMessageId(counter);
			counter++;
			Date date = new Date();
			tmsMessage.setMessageDateTime(date);

			/** Get XML Packet */
			tmsMessage.marshal(writer);

			return writer.toString();
		} catch (Exception e) {
			System.out.println("EXCEPTION! : " + e.toString());
			return null;
		}
	}

	/**
	 * This method is being used for the compilation of enquiry ncb
	 * address xml which is used to get the address data of the 
	 * specified ncb from TMS.
	 * @param user User details that are being used for enquiry
	 * ncb address.
	 * @param card The credit card details that are being used for enquiry
	 * ncb address.
	 * @return String The xml string that represents enquiry ncb address.
	 */
	public String enquiryNcbAddressXml(User_Data user, CreditCard_Data card) {
		try {

			StringWriter writer = new StringWriter();
			System.out.println("Started...");

			/** Initialise */
			TmsMessage tmsMessage = new TmsMessage();

			MessageAuthBlk mab = new MessageAuthBlk();
			MessageTypeChoice mtc = new MessageTypeChoice();

			MessageEnquiryBlk menquiryb = new MessageEnquiryBlk();
			EnquiryNcbAddress ena = new EnquiryNcbAddress();

			NcbAddress na = new NcbAddress();
			NcbAddressTypeType ncbaddresstypetype =
				NcbAddressTypeType.valueOf("Billing");

			/** set simpleTypes */
			na.setSelectedAddressType(ncbaddresstypetype);

			ena.setNcbId(user.getNcbId());

			/** Add to parent */
			ena.addNcbAddress(na);
			menquiryb.setEnquiryNcbAddress(ena);
			mtc.setMessageEnquiryBlk(menquiryb);
			tmsMessage.setMessageTypeChoice(mtc);

			/** Set attributes */
			mab.setNcbId(user.getNcbId());
			tmsMessage.setMessageAuthBlk(mab); //adding attribute.
			tmsMessage.setMessageId(counter);
			counter++;
			Date date = new Date();
			tmsMessage.setMessageDateTime(date);

			/** Get XML Packet */
			tmsMessage.marshal(writer);

			return writer.toString();
		} catch (Exception e) {
			System.out.println("EXCEPTION! : " + e.toString());
			return null;
		}
	}
}
